package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Tablones;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TablonesDaoImpl generated by UDA, 25-abr-2016 15:47:19.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TablonesDaoImpl implements TablonesDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Tablones> rwMap = new RowMapper<Tablones>() {
		public Tablones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tablones(resultSet.getString("CODTABLA088"),
					resultSet.getString("CODIGO088"),
					resultSet.getString("DESCRIPCION088"),
					resultSet.getString("DESCRIPCIONEUS088"),
					resultSet.getString("FECHABAJA088"));
		}
	};

	private RowMapper<Tablones> rwMapVista = new RowMapper<Tablones>() {
		public Tablones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tablones(resultSet.getString("CODTABLA088"));
		}
	};

	private RowMapper<Tablones> rwMapPK = new RowMapper<Tablones>() {
		public Tablones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Tablones(resultSet.getString("CODTABLA088"),
					resultSet.getString("CODIGO088"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Tablones table.
	 * 
	 * tablones Tablones Tablones
	 *
	 * @param tablones
	 *            the tablones
	 * @return the tablones
	 */
	public Tablones add(Tablones tablones) {
		String query = "INSERT INTO AB0488S00 (CODTABLA_088, CODIGO_088, DESCRIPCION_088, DESCRIPCION_EUS_088, FECHA_BAJA_088) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, tablones.getCodtabla088(),
				tablones.getCodigo088(), tablones.getDescripcion088(),
				tablones.getDescripcionEus088(), tablones.getFechaBaja088());
		return tablones;
	}

	/**
	 * Updates a single row in the Tablones table.
	 * 
	 * tablones Tablones Tablones
	 *
	 * @param tablones
	 *            the tablones
	 * @return the tablones
	 */
	public Tablones update(Tablones tablones) {
		String query = "UPDATE AB0488S00 SET   DESCRIPCION_088=? , DESCRIPCION_EUS_088=? , FECHA_BAJA_088=? WHERE CODTABLA_088=? AND CODIGO_088=?";
		this.jdbcTemplate.update(query, tablones.getDescripcion088(),
				tablones.getDescripcionEus088(), tablones.getFechaBaja088(),
				tablones.getCodtabla088(), tablones.getCodigo088());
		return tablones;
	}

	/**
	 * Finds a single row in the Tablones table.
	 * 
	 * tablones Tablones Tablones
	 *
	 * @param tablones
	 *            the tablones
	 * @return the tablones
	 */
	@Transactional(readOnly = true)
	public Tablones find(Tablones tablones) {
		String query = "SELECT t1.CODTABLA_088 CODTABLA088, t1.CODIGO_088 CODIGO088, t1.DESCRIPCION_088 DESCRIPCION088, t1.DESCRIPCION_EUS_088 DESCRIPCIONEUS088, TO_CHAR(t1.FECHA_BAJA_088, 'DD/MM/YYYY') FECHABAJA088 FROM AB0488S00 t1  WHERE 1 = 1 AND t1.CODTABLA_088 = ?   AND t1.CODIGO_088 = ?  ";

		List<Tablones> tablonesList = this.jdbcTemplate.query(query, this.rwMap,
				tablones.getCodtabla088(), tablones.getCodigo088());
		return (Tablones) DataAccessUtils.uniqueResult(tablonesList);
	}

	/**
	 * Removes a single row in the Tablones table.
	 * 
	 * tablones Tablones
	 *
	 * @param tablones
	 *            the tablones
	 */
	public void remove(Tablones tablones) {
		String query = "DELETE FROM AB0488S00 WHERE CODTABLA_088=? AND CODIGO_088=?";
		this.jdbcTemplate.update(query, tablones.getCodtabla088(),
				tablones.getCodigo088());
	}

	/**
	 * Finds a list of rows in the Tablones table.
	 * 
	 * tablones Tablones jqGridRequestDto JQGridRequestDto List<Tablones>
	 *
	 * @param tablones
	 *            the tablones
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Tablones> findAll(Tablones tablones,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODTABLA_088 CODTABLA088,t1.CODIGO_088 CODIGO088,t1.DESCRIPCION_088 DESCRIPCION088,t1.DESCRIPCION_EUS_088 DESCRIPCIONEUS088,TO_CHAR(t1.FECHA_BAJA_088, 'DD/MM/YYYY') FECHABAJA088 ");
		query.append("FROM AB0488S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tablones);
		StringBuilder where = new StringBuilder(" WHERE 1 = 1   ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Tablones>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Tablones table.
	 * 
	 * tablones Tablones jqGridRequestDto JQGridRequestDto List<Tablones>
	 *
	 * @param tablones
	 *            the tablones
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Tablones> vistafindAll(Tablones tablones,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct  t1.CODTABLA_088 CODTABLA088 ");
		query.append("  FROM AB0488S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tablones);
		StringBuilder where = new StringBuilder(" WHERE 1 = 1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Tablones>) this.jdbcTemplate.query(query.toString(),
				this.rwMapVista, params.toArray());
	}

	/**
	 * Finds rows in the Tablones table using like.
	 * 
	 * tablones Tablones jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Tablones>
	 *
	 * @param tablones
	 *            the tablones
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Tablones> findAllLike(Tablones tablones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODTABLA_088 CODTABLA088,t1.CODIGO_088 CODIGO088,t1.DESCRIPCION_088 DESCRIPCION088,t1.DESCRIPCION_EUS_088 DESCRIPCIONEUS088,TO_CHAR(t1.FECHA_BAJA_088, 'DD/MM/YYYY') FECHABAJA088 ");
		query.append("FROM AB0488S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tablones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1 = 1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Tablones>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Tablones table.
	 * 
	 * tablones Tablones Long
	 *
	 * @param tablones
	 *            the tablones
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Tablones tablones) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0488S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tablones);
		StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Tablones table using like.
	 * 
	 * tablones Tablones startsWith Boolean Long
	 *
	 * @param tablones
	 *            the tablones
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Tablones tablones, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0488S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tablones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1 = 1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Tablones selected for rup_table.
	 * 
	 * tablones Tablones jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Tablones>>
	 *
	 * @param tablones
	 *            the tablones
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Tablones>> reorderSelection(Tablones tablones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODTABLA_088 CODTABLA088,t1.CODIGO_088 CODIGO088,t1.DESCRIPCION_088 DESCRIPCION088,t1.DESCRIPCION_EUS_088 DESCRIPCIONEUS088,TO_CHAR(t1.FECHA_BAJA_088, 'DD/MM/YYYY') FECHABAJA088 ");
		// FROM
		query.append("FROM AB0488S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tablones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1 = 1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Tablones.class, filterParamList,
				"CODTABLA_088,CODIGO_088,DESCRIPCION_088,DESCRIPCION_EUS_088,FECHA_BAJA_088");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Tablones>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tablones entity.
	 * 
	 * tablones Tablones Bean with the criteria values to filter by. Map created
	 * with two keys key query stores the sql query syntax key params stores the
	 * parameter values to be used in the condition sentence.
	 *
	 * @param tablones
	 *            the tablones
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Tablones tablones) {

		StringBuilder where = new StringBuilder(
				TablonesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tablones != null && tablones.getCodtabla088() != null) {
			where.append(" AND t1.CODTABLA_088 = ?");
			params.add(tablones.getCodtabla088());
		}
		if (tablones != null && tablones.getCodigo088() != null) {
			where.append(" AND t1.CODIGO_088 = ?");
			params.add(tablones.getCodigo088());
		}
		if (tablones != null && tablones.getDescripcion088() != null) {
			where.append(" AND t1.DESCRIPCION_088 = ?");
			params.add(tablones.getDescripcion088());
		}
		if (tablones != null && tablones.getDescripcionEus088() != null) {
			where.append(" AND t1.DESCRIPCION_EUS_088 = ?");
			params.add(tablones.getDescripcionEus088());
		}

		where.append(
				" AND (t1.FECHA_BAJA_088 < SYSDATE OR t1.FECHA_BAJA_088 IS NULL) ");

		if (tablones != null && tablones.getSistema() != null) {
			where.append(" AND t1.SISTEMA_088 = ? ");
			params.add(tablones.getSistema());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Tablones entity.
	 * 
	 * tablones Tablones Bean with the criteria values to filter by. startsWith
	 * Boolean Map created with two keys key query stores the sql query syntax
	 * key params stores the parameter values to be used in the condition
	 * sentence.
	 *
	 * @param tablones
	 *            the tablones
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Tablones tablones,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TablonesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tablones != null && tablones.getCodtabla088() != null) {
			where.append(" AND UPPER(t1.CODTABLA_088) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tablones.getCodtabla088().toUpperCase() + "%");
			} else {
				params.add("%" + tablones.getCodtabla088().toUpperCase() + "%");
			}
			where.append(" AND t1.CODTABLA_088 IS NOT NULL");
		}
		if (tablones != null && tablones.getCodigo088() != null) {
			where.append(" AND UPPER(t1.CODIGO_088) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tablones.getCodigo088().toUpperCase() + "%");
			} else {
				params.add("%" + tablones.getCodigo088().toUpperCase() + "%");
			}
			where.append(" AND t1.CODIGO_088 IS NOT NULL");
		}
		if (tablones != null && tablones.getDescripcion088() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_088) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tablones.getDescripcion088().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tablones.getDescripcion088().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_088 IS NOT NULL");
		}
		if (tablones != null && tablones.getDescripcionEus088() != null) {
			where.append(
					" AND UPPER(t1.DESCRIPCION_EUS_088) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tablones.getDescripcionEus088().toUpperCase() + "%");
			} else {
				params.add("%" + tablones.getDescripcionEus088().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION_EUS_088 IS NOT NULL");
		}
		where.append(
				" AND (t1.FECHA_BAJA_088 < SYSDATE OR t1.FECHA_BAJA_088 IS NULL) ");

		if (tablones != null && tablones.getSistema() != null) {
			where.append(" AND t1.SISTEMA_088 = ? ");
			params.add(tablones.getSistema());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
